<?
/*
	PHP-Quellcode zum Tutorial "Mchtiv viel Druck machen"
	PDF-Dokumente lizenzfrei mit PHP erzeugen
	
	(c) Ulrich Hacke
	TRILOS IT-Dienstleistungen
	Am Rathaus 15
	30952 Ronnenberg
	eMail: hacke@trilos.de
*/

// Fonts fr FPDF
define("FPDF_FONTPATH","fpdf/font/");
// FPDF einbinden
include "fpdf/fpdf.php";

// Abgeleitete PDFDOC-Klasse
class PDFDoc extends FPDF {
	// bergeordnetes Objekt
	var $pdf;
	// PDF im Konstruktor erstellen
	function PDFDoc() {
		$this->pdf = new FPDF("P", "mm", "A4");
		$this->pdf->SetTitle("PDF-Vortrag");
		$this->pdf->AliasNbPages(); 
		$this->pdf->Open();
		$this->pdf->SetMargins(25,25,20);
		$this->pdf->AddPage();
	}
	
	// berschrift hinzufgen
	function AddHeading($text) {
		// Font stzen
		$this->pdf->SetFont("Times", "B", 14);
		// berschrift ausgeben
		$this->pdf->Write(5, $text);
		// Abstand
		$this->pdf->Ln(10);
	}
	
	// Absatz hinzufgen
	function AddParagraph($text) {
		$this->pdf->SetFont("Times", "", 11);
		$this->pdf->Write(5, $text);
		$this->pdf->Ln(10);
	}
	
	// mySQL-Tabellenstruktur ausgeben
	function mySQLTable($dbh, $table) {
		// Felder der Tabelle auslesen
		$query = mysql_query("show fields from ".$table, $dbh);
		if(mysql_affected_rows($dbh)>0) {
			// Tabellenlayot vorbereiten
			$this->pdf->SetFont("Helvetica", "B",14);
			$this->pdf->SetFillColor(200,200,200);
			$this->pdf->Write(5, "Tabellenstruktur von \"$table\"");
			$this->pdf->SetFont("","",11);
			$this->pdf->Ln(8);
			
			// Kopfzeilen schreiben
			$this->pdf->Cell(55,5,"Field",1,0,"C",1);
			$this->pdf->Cell(30,5,"Type",1,0,"C",1);
			$this->pdf->Cell(20,5,"Null",1,0,"C",1);
			$this->pdf->Cell(35,5,"Extra",1,1,"C",1);
			
			// Datenstze der Feldzeilen ausgeben
			while($row = mysql_fetch_array($query)) {
				$this->pdf->Cell(55,5,$row["Field"],1,0,"",0);
				$this->pdf->Cell(30,5,$row["Type"],1,0,"",0);
				$this->pdf->Cell(20,5,($row["Null"]=="") ? "No":"Yes",1,0,"",0);
				$this->pdf->Cell(35,5,$row["Extra"],1,1,"",0);
			}
			// Abstand
			$this->pdf->Ln(10);
		}
	}
	
	// Grafische Spielerei
	function fancyGraphic() {
		for($x=10;$x<=200;$x++) {
			$y = 60+49*sin($x/20);
			// Malfarbe verndern
			$this->pdf->SetDrawColor(100,200-$x,$x);
			// Linie zeichen
			$this->pdf->Line($x, $y, $y, 100-$y/2);
			$this->pdf->Line($y, (100-$y/2)+100, $y+100, $x);
		}
	}
	
	// Einfaches Diagramm
	function simpleDiagram($title, $data, $color="0000e0") {
		// Font setzen
		$this->pdf->SetFont("Times", "B", 14);
		// Titel ausgeben
		$this->pdf->Write(5, $title);
		$this->pdf->Ln(8);
		$this->pdf->SetFont("Times", "", 11);
		// Malfarbe setzen
		$this->pdf->SetFillColor(hexdec(substr($color,0,2)),hexdec(substr($color,2,2)), hexdec(substr($color,4,2)));
		// Werte analysieren
		while(list($key, $value) = each($data)) {
			// Breitestes Label
			if($this->pdf->GetStringWidth($key)>$kmax) $kmax = $this->pdf->GetStringWidth($key)+5;
			// Grter Datenwert
			if($value>$vmax) $vmax = $value;
		}
		$faktor = (150-$kmax)/$vmax;
		// Daten ausgeben
		reset($data);
		while(list($key, $value) = each($data)) {
			// Label
			$this->pdf->Cell($kmax,5,$key,0,0,"R");
			// Balken
			$this->pdf->Cell($value*$faktor,5," ",0,0,"C",1);
			// Beschriftung
			$this->pdf->Cell(0,5,number_format($value,0,",","."),0,1,"L");
			$this->pdf->Ln(1);
		}
		// Abstand
		$this->pdf->Ln(5);
	}
	
	function Display() {
		header("Content-type: application/pdf");
		$this->pdf->Output();
	}
}

// Beispiel 5.1: Links
// -------------------

/*
$pdf = new FPDF("P", "mm", "A4");
$pdf->SetTitle("PDF-Vortrag");
$pdf->AliasNbPages(); 
$pdf->Open();
$pdf->SetMargins(25,25,20);

$pdf->AddPage();

$pdf->SetFont("Times","",11);

$link = $pdf->AddLink();
$pdf->SetLink($link,0,2);
$pdf->Write(5, "Seite 1\n");
$pdf->SetTextColor(0,0,200);
$pdf->Write(5, "Gehe zu Seite 2", $link);

$pdf->AddPage();

$pdf->SetTextColor(0,0,0);
$pdf->Write(5,"Seite 2\n");
$pdf->SetTextColor(0,0,200);
$pdf->Write(5,"http://www.trilos.de", "http://www.trilos.de");

header("Content-type: application/pdf");
$pdf->Output();
*/
// -------------------


// Beispiel 5.3.: Dokument aus Bausteinen zusammensetzen
// -----------------------------------------------------
/*
$d = new PDFDoc();
for($i=1;$i<5;$i++) {
	$d->AddHeading($i.". Kapitel");
	$d->AddParagraph(str_repeat("Gallia est omnia divisa in partes tres. ", 4+($i*2)));
}
$d->Display();
*/
// -----------------------------------------------------


// Beispiel 5.4: Grafikausgebe
// ---------------------------
/*
$d = new PDFDoc();
$d->fancyGraphic();
$d->Display();
*/
// ---------------------------


// Beispiel 5.5: Einfaches Diagramm
// --------------------------------
/*
$d = new PDFDoc();
$d->simpleDiagram("Zusammensetzung des Deutschen Bundestages (2002-2004)", array("SPD"=>251, "CDU/CSU"=>247, "B90/Die Grnen"=>55, "FDP"=>47, "fraktionslos"=>3),"ffa07a");
$d->simpleDiagram("Flchen einiger Bundeslnder (Quadratkilometer)", array("Baden-Wrttemberg"=>35751, "Bayern"=>70554, "Brandenburg"=>29061, "Hessen"=>21114, "Niedersachsen"=>47344, "Rheinland-Pfalz"=>19849, "Thringen"=>16254),"2e8b57");
$d->Display();
*/
// --------------------------------


// Beispiel 5.6: mySQL-Operationen
// -------------------------------
/*
// Verbindung zur Datenbank
$dbh = mysql_connect("localhost", "root", "");
mysql_select_db("demo");
$d = new PDFDoc();
$d->mySQLTable($dbh, "mitarbeiter");
$d->Display();
*/
// -------------------------------
?>